/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.base.VWConfigAttributesTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWConfigURLTemplatePanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    public static final int TYPE_SP = 0;
    public static final int TYPE_LSP = 1;
    private VWAttributeInfo m_vwAttributeInfo = null;
    private Dialog m_parentDialog = null;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_urlTemplateTable = null;
    private VWConfigAttributesTableModel m_tableModel = null;

    public VWConfigURLTemplatePanel(Dialog parentDialog, VWAttributeInfo vwAttributeInfo, VWSessionInfo sessionInfo, int nType) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_vwAttributeInfo = vwAttributeInfo;
            this.createControls(parentDialog, sessionInfo, nType);
            this.m_urlTemplateTable.clearSelection();
            if (this.m_urlTemplateTable.getRowCount() > 0) {
                this.m_urlTemplateTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        this.stopTableEditing();
        return this.m_tableModel.hasChanged();
    }

    public boolean stopTableEditing() {
        if (this.m_urlTemplateTable != null) {
            this.m_urlTemplateTable.stopEditing();
        }
        return true;
    }

    public boolean update() {
        boolean bSuccess = true;
        this.stopTableEditing();
        bSuccess = this.m_tableModel.verifySettings();
        if (bSuccess) {
            bSuccess = this.m_tableModel.update();
        }
        return bSuccess;
    }

    public void releaseResources() {
        this.m_vwAttributeInfo = null;
        this.m_parentDialog = null;
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseReferences();
            this.m_toolBarBorder = null;
        }
        if (this.m_urlTemplateTable != null) {
            this.m_urlTemplateTable.removeAll();
            this.m_urlTemplateTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.removeAll();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_urlTemplateTable.getSelectedRow()) {
                    this.m_urlTemplateTable.clearSelection();
                }
                this.m_urlTemplateTable.setRowSelectionInterval(nRow, nRow);
                this.m_urlTemplateTable.ensureRowIsVisible(nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_urlTemplateTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_urlTemplateTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex < this.m_tableModel.getMinimumRowCount() || nLastIndex < this.m_tableModel.getMinimumRowCount()) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopTableEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_urlTemplateTable.setRowSelectionInterval(nRow, nRow);
                    this.m_urlTemplateTable.setColumnSelectionInterval(0, 0);
                    this.m_urlTemplateTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createControls(Dialog parentDialog, VWSessionInfo sessionInfo, int nType) {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.createURLTemplatePanel(parentDialog, sessionInfo, nType);
            this.add((Component)this.m_toolBarBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createURLTemplatePanel(Dialog parentDialog, VWSessionInfo sessionInfo, int nType) {
        try {
            String toolbarTitle = null;
            String keyPrefix = null;
            switch (nType) {
                case 1: {
                    toolbarTitle = VWResource.LaunchStepProcessorURLTemplates;
                    keyPrefix = "F_LSPTemplate";
                    break;
                }
                case 0: {
                    toolbarTitle = VWResource.StepProcessorURLTemplates;
                    keyPrefix = "F_SPTemplate";
                }
            }
            this.m_toolBarBorder = new VWToolbarBorder(toolbarTitle, 0x10000010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigAttributesTableModel(parentDialog, this.m_vwAttributeInfo, VWResource.Template, keyPrefix);
            this.m_tableModel.addTableModelListener(this);
            this.m_urlTemplateTable = new VWTable(this.m_tableModel);
            this.m_urlTemplateTable.setRowSelectionAllowed(true);
            this.m_urlTemplateTable.getSelectionModel().addListSelectionListener(this);
            this.m_urlTemplateTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_urlTemplateTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_urlTemplateTable), "Center");
            VWAccessibilityHelper.setAccessibility(this.m_urlTemplateTable, this, toolbarTitle, toolbarTitle);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteRows() {
        try {
            this.stopTableEditing();
            int[] rows = this.m_urlTemplateTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

